
function normalLookup(){
   var lookup = new Array();
   for(var i = 0; i<256;i++){
	    lookup[i] = i;
	    }
   return lookup;
   }
///////////////////////////////
function invertLookup(){
   var lookup = new Array();
   for(var i = 0; i<256;i++){
	    lookup[i] = Math.floor(255-i);
	    }
   return lookup;
   }
///////////////////////////////
function contrastLookup(wert,middle){
   var lookup = new Array();
   for(var i = 0; i<256;i++){
	    
	    lookup[i] = Math.min(Math.max(middle+((i-middle)+((i>middle)?(wert):(-wert))),0),255);
	    //lookup[i] =Math.min(Math.max((middle+(i-middle)*wert),0),255);
	    }
   return lookup;
   }   
  
///////////////////////////////
function lichtLookup(wert){
   if(wert<(-255))wert=(-255);
   if(wert>255)wert=255;
   var lookup = new Array();
   
   for(var i = 0; i<256;i++){
	    if(wert>0)lookup[i] = Math.floor(wert+i*((255-wert)/255));
      if(wert<0)lookup[i] = Math.floor((i/255)*(255+wert));
	    if(lookup[i]<0) lookup[i]=0;
	    if(lookup[i]>255) lookup[i]=255;
	    }
	 return lookup;
   }
///////////////////////////////////////////////
/*

How to use this:
1. save all Tiles using CloneTiles();
2. use lookupMap(red_lookup,green_lookup,blue_lookup,alpha_lookup) to change the map
3. use ClearLookup to get the map-lookup,which CloneTiles saved.

*/


///////////////////////////////////////////////
var Tileclone = new Array();
function CloneTiles(){
   
   for(var i=0;i<GetNumTiles();i++){
      Tileclone[i]=GetTileSurface(i);
      }
   
   }
///////////////////////////////
function ClearLookup(){
   
   for(var i=0;i<GetNumTiles();i++){
      SetTileSurface(i,Tileclone[i]);
      }
   
   var list = GetPersonList();
   
   for(var i=0;i<list.length;i++){
			for(var k=0;k<__savedSpritesets.length;k++){
			
				if(__savedSpritesets[k][0]==list[i]){
					SetPersonSpriteset(__savedSpritesets[k][0],__savedSpritesets[k][1].clone());
					}
				}
			}
  
   }
///////////////////////////////
var __savedLookup = undefined;
var __savedSpritesets = [];
function fastSaveLookup(r,g,b,a){

	__savedLookup = [r,g,b,a];

}
///////////////////////////////


function lookupMap(r,g,b,a,keepPersons){
   if(keepPersons==undefined)keepPersons = false;
   fastSaveLookup(r,g,b,a);
   var tilesurface = "";
   for(var i=0;i<GetNumTiles();i++){
      tilesurface=GetTileSurface(i);
      tilesurface.applyLookup(0, 0, tilesurface.width, tilesurface.height,r,g,b,a);
      SetTileSurface(i,tilesurface);
      }
   var list = GetPersonList();
   var spriteset = undefined;
   var helpersurface = undefined;
   var actualized = [];
   var foundPerson = false;
   
   for(var i=0;i<list.length;i++){
		
		spriteset = GetPersonSpriteset(list[i]);
		foundPerson = false;
		for(var k=0;k<__savedSpritesets.length;k++){
			
			if(__savedSpritesets[k][0]==list[i]){
				spriteset = __savedSpritesets[k][1].clone();
				actualized.push(__savedSpritesets[k]);
				foundPerson = true;
				}
			
			}
		if(!foundPerson){
			actualized.push([list[i],spriteset.clone()]);
			}	
			
		for(var j=0;j<spriteset.images.length;j++){
			if(!keepPersons){
				helpersurface = spriteset.images[j].createSurface();
				helpersurface.applyLookup(0, 0, helpersurface.width, helpersurface.height,r,g,b,a);
				spriteset.images[j] = helpersurface.createImage();
				}
			
			}
		SetPersonSpriteset(list[i],spriteset);
		}
		__savedSpritesets = actualized;
		
   }
   
///////////////////////////////
function reapplyLookupMap(){
	
	if(__savedLookup==undefined)return;
	ClearLookup();
	lookupMap(__savedLookup[0],__savedLookup[1],__savedLookup[2],__savedLookup[3]);

}

///////////////////////////////
///////////////////////////////
function GetTileByName(name){
	if(IsMapEngineRunning()){
		for(var i=0;i<GetNumTiles();i++){
			if(GetTileName(i)==name)return i;
			}
		}
	return -1;
	}